/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.ruleChain;

import lombok.Generated;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.msg.TbActorStopReason;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbRuleEngineActorMsg;
import org.thingsboard.server.common.msg.aware.RuleChainAwareMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;

public abstract class TbToRuleChainActorMsg
extends TbRuleEngineActorMsg
implements RuleChainAwareMsg {
    private final RuleChainId target;

    public TbToRuleChainActorMsg(TbMsg msg, RuleChainId target) {
        super(msg);
        this.target = target;
    }

    public RuleChainId getRuleChainId() {
        return this.target;
    }

    public void onTbActorStopped(TbActorStopReason reason) {
        String message = reason == TbActorStopReason.STOPPED ? String.format("Rule chain [%s] stopped", this.target.getId()) : String.format("Failed to initialize rule chain [%s]!", this.target.getId());
        this.msg.getCallback().onFailure(new RuleEngineException(message));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbToRuleChainActorMsg)) {
            return false;
        }
        TbToRuleChainActorMsg other = (TbToRuleChainActorMsg)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleChainId this$target = this.getTarget();
        RuleChainId other$target = other.getTarget();
        return !(this$target == null ? other$target != null : !this$target.equals(other$target));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TbToRuleChainActorMsg;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RuleChainId $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TbToRuleChainActorMsg(target=" + String.valueOf(this.getTarget()) + ")";
    }

    @Generated
    public RuleChainId getTarget() {
        return this.target;
    }
}

