/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.ruleChain;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbRuleNodeUpdateException;
import org.thingsboard.server.actors.ruleChain.DefaultTbContext;
import org.thingsboard.server.actors.ruleChain.RuleChainToRuleNodeMsg;
import org.thingsboard.server.actors.ruleChain.RuleNodeCtx;
import org.thingsboard.server.actors.ruleChain.RuleNodeToSelfMsg;
import org.thingsboard.server.actors.shared.ComponentMsgProcessor;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleState;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.RuleNodeException;
import org.thingsboard.server.common.msg.queue.RuleNodeInfo;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.gen.transport.TransportProtos;

public class RuleNodeActorMessageProcessor
extends ComponentMsgProcessor<RuleNodeId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleNodeActorMessageProcessor.class);
    private static final String UNKNOWN_NAME = "Unknown";
    private final String ruleChainName;
    private final TbApiUsageReportClient apiUsageClient;
    private final DefaultTbContext defaultCtx;
    private RuleNode ruleNode;
    private TbNode tbNode;
    private RuleNodeInfo info;

    RuleNodeActorMessageProcessor(TenantId tenantId, String ruleChainName, RuleNodeId ruleNodeId, ActorSystemContext systemContext, TbActorCtx selfActor) {
        super(systemContext, tenantId, ruleNodeId);
        this.apiUsageClient = systemContext.getApiUsageClient();
        this.ruleChainName = ruleChainName;
        this.ruleNode = systemContext.getRuleChainService().findRuleNodeById(tenantId, (RuleNodeId)this.entityId);
        this.defaultCtx = new DefaultTbContext(systemContext, ruleChainName, new RuleNodeCtx(tenantId, selfActor, this.ruleNode));
        this.info = new RuleNodeInfo(ruleNodeId, ruleChainName, this.getName(this.ruleNode));
    }

    @Override
    public void start(TbActorCtx context) throws Exception {
        if (this.isMyNodePartition()) {
            log.debug("[{}][{}] Starting", (Object)this.tenantId, (Object)this.entityId);
            this.tbNode = this.initComponent(this.ruleNode);
            if (this.tbNode != null) {
                this.state = ComponentLifecycleState.ACTIVE;
            }
        }
    }

    @Override
    public void onUpdate(TbActorCtx context) throws Exception {
        RuleNode newRuleNode = this.systemContext.getRuleChainService().findRuleNodeById(this.tenantId, (RuleNodeId)this.entityId);
        if (this.isMyNodePartition(newRuleNode)) {
            this.info = new RuleNodeInfo((RuleNodeId)this.entityId, this.ruleChainName, this.getName(newRuleNode));
            boolean restartRequired = this.state != ComponentLifecycleState.ACTIVE || !this.ruleNode.getType().equals(newRuleNode.getType()) || !this.ruleNode.getConfiguration().equals((Object)newRuleNode.getConfiguration());
            this.ruleNode = newRuleNode;
            this.defaultCtx.updateSelf(newRuleNode);
            if (restartRequired) {
                if (this.tbNode != null) {
                    this.tbNode.destroy();
                }
                try {
                    this.start(context);
                }
                catch (Exception e) {
                    throw new TbRuleNodeUpdateException("Failed to update rule node", (Throwable)e);
                }
            }
        } else if (this.tbNode != null) {
            this.stop(null);
            this.tbNode = null;
        }
    }

    @Override
    public void stop(TbActorCtx context) {
        log.debug("[{}][{}] Stopping", (Object)this.tenantId, (Object)this.entityId);
        if (this.tbNode != null) {
            this.tbNode.destroy();
            this.state = ComponentLifecycleState.SUSPENDED;
        }
    }

    @Override
    public void onPartitionChangeMsg(PartitionChangeMsg msg) throws Exception {
        log.debug("[{}][{}] onPartitionChangeMsg: [{}]", new Object[]{this.tenantId, this.entityId, msg});
        if (this.tbNode != null) {
            if (!this.isMyNodePartition()) {
                this.stop(null);
                this.tbNode = null;
            } else {
                this.tbNode.onPartitionChangeMsg((TbContext)this.defaultCtx, msg);
            }
        } else if (this.isMyNodePartition()) {
            this.start(null);
        }
    }

    public void onRuleToSelfMsg(RuleNodeToSelfMsg msg) throws Exception {
        this.checkComponentStateActive(msg.getMsg());
        TbMsg tbMsg = msg.getMsg();
        int ruleNodeCount = tbMsg.getAndIncrementRuleNodeCounter();
        TenantProfileConfiguration tenantProfileConfiguration = this.getTenantProfileConfiguration();
        int maxRuleNodeExecutionsPerMessage = tenantProfileConfiguration.getMaxRuleNodeExecsPerMessage();
        if (maxRuleNodeExecutionsPerMessage == 0 || ruleNodeCount < maxRuleNodeExecutionsPerMessage) {
            this.apiUsageClient.report(this.tenantId, tbMsg.getCustomerId(), ApiUsageRecordKey.RE_EXEC_COUNT);
            this.persistDebugInputIfAllowed(msg.getMsg(), "Self");
            try {
                this.tbNode.onMsg((TbContext)this.defaultCtx, msg.getMsg());
            }
            catch (Exception e) {
                this.defaultCtx.tellFailure(msg.getMsg(), e);
            }
        } else {
            tbMsg.getCallback().onFailure((RuleEngineException)new RuleNodeException("Message is processed by more then " + maxRuleNodeExecutionsPerMessage + " rule nodes!", this.ruleChainName, this.ruleNode));
        }
    }

    void onRuleChainToRuleNodeMsg(RuleChainToRuleNodeMsg msg) throws Exception {
        if (!this.isMyNodePartition()) {
            this.putToNodePartition(msg.getMsg());
        } else {
            msg.getMsg().getCallback().onProcessingStart(this.info);
            this.checkComponentStateActive(msg.getMsg());
            TbMsg tbMsg = msg.getMsg();
            int ruleNodeCount = tbMsg.getAndIncrementRuleNodeCounter();
            TenantProfileConfiguration tenantProfileConfiguration = this.getTenantProfileConfiguration();
            int maxRuleNodeExecutionsPerMessage = tenantProfileConfiguration.getMaxRuleNodeExecsPerMessage();
            if (maxRuleNodeExecutionsPerMessage == 0 || ruleNodeCount < maxRuleNodeExecutionsPerMessage) {
                this.apiUsageClient.report(this.tenantId, tbMsg.getCustomerId(), ApiUsageRecordKey.RE_EXEC_COUNT);
                this.persistDebugInputIfAllowed(msg.getMsg(), msg.getFromRelationType());
                try {
                    this.tbNode.onMsg(msg.getCtx(), msg.getMsg());
                }
                catch (Exception e) {
                    msg.getCtx().tellFailure(msg.getMsg(), (Throwable)e);
                }
            } else {
                tbMsg.getCallback().onFailure((RuleEngineException)new RuleNodeException("Message is processed by more then " + maxRuleNodeExecutionsPerMessage + " rule nodes!", this.ruleChainName, this.ruleNode));
            }
        }
    }

    @Override
    public String getComponentName() {
        return this.getName(this.ruleNode);
    }

    private String getName(RuleNode ruleNode) {
        return ruleNode != null ? ruleNode.getName() : UNKNOWN_NAME;
    }

    private TbNode initComponent(RuleNode ruleNode) throws Exception {
        TbNode tbNode = null;
        if (ruleNode != null) {
            Class<?> componentClazz = Class.forName(ruleNode.getType());
            tbNode = (TbNode)componentClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            tbNode.init((TbContext)this.defaultCtx, new TbNodeConfiguration(ruleNode.getConfiguration()));
        }
        return tbNode;
    }

    @Override
    protected RuleNodeException getInactiveException() {
        return new RuleNodeException("Rule Node is not active! Failed to initialize.", this.ruleChainName, this.ruleNode);
    }

    private boolean isMyNodePartition() {
        return this.isMyNodePartition(this.ruleNode);
    }

    private boolean isMyNodePartition(RuleNode ruleNode) {
        boolean result;
        boolean bl = result = ruleNode == null || !ruleNode.isSingletonMode() || this.systemContext.getDiscoveryService().isMonolith() || this.defaultCtx.isLocalEntity((EntityId)ruleNode.getId());
        if (!result) {
            log.trace("[{}][{}] Is not my node partition", (Object)this.tenantId, (Object)this.entityId);
        }
        return result;
    }

    private void putToNodePartition(TbMsg source) {
        TbMsg tbMsg = TbMsg.newMsg((TbMsg)source, (String)source.getQueueName(), (RuleChainId)source.getRuleChainId(), (RuleNodeId)((RuleNodeId)this.entityId));
        TopicPartitionInfo tpi = this.systemContext.resolve(ServiceType.TB_RULE_ENGINE, tbMsg.getQueueName(), this.tenantId, (EntityId)this.ruleNode.getId());
        TransportProtos.ToRuleEngineMsg toQueueMsg = TransportProtos.ToRuleEngineMsg.newBuilder().setTenantIdMSB(this.tenantId.getId().getMostSignificantBits()).setTenantIdLSB(this.tenantId.getId().getLeastSignificantBits()).setTbMsgProto(TbMsg.toProto((TbMsg)tbMsg)).build();
        this.systemContext.getClusterService().pushMsgToRuleEngine(tpi, tbMsg.getId(), toQueueMsg, null);
        this.defaultCtx.ack(source);
    }

    private void persistDebugInputIfAllowed(TbMsg msg, String fromNodeConnectionType) {
        if (DebugModeUtil.isDebugAllAvailable((HasDebugSettings)this.ruleNode)) {
            this.systemContext.persistDebugInput(this.tenantId, this.entityId, msg, fromNodeConnectionType);
        }
    }
}

