/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.app;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.ProcessFailureStrategy;
import org.thingsboard.server.actors.TbActor;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbEntityActorId;
import org.thingsboard.server.actors.device.SessionTimeoutCheckMsg;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.actors.service.ContextBasedCreator;
import org.thingsboard.server.actors.tenant.TenantActor;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.ToCalculatedFieldSystemMsg;
import org.thingsboard.server.common.msg.aware.TenantAwareMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.QueueToRuleEngineMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.service.transport.msg.TransportToDeviceActorMsgWrapper;

public class AppActor
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppActor.class);
    private final TenantService tenantService;
    private final Set<TenantId> deletedTenants;
    private volatile boolean ruleChainsInitialized;

    private AppActor(ActorSystemContext systemContext) {
        super(systemContext);
        this.tenantService = systemContext.getTenantService();
        this.deletedTenants = new HashSet<TenantId>();
    }

    public void init(TbActorCtx ctx) throws TbActorException {
        super.init(ctx);
        if (this.systemContext.getServiceInfoProvider().isService(ServiceType.TB_CORE)) {
            this.systemContext.schedulePeriodicMsgWithDelay((TbActorRef)ctx, SessionTimeoutCheckMsg.instance(), this.systemContext.getSessionReportTimeout(), this.systemContext.getSessionReportTimeout());
        }
    }

    @Override
    protected boolean doProcess(TbActorMsg msg) {
        if (!this.ruleChainsInitialized) {
            if (MsgType.APP_INIT_MSG.equals((Object)msg.getMsgType())) {
                this.initTenantActors();
                this.ruleChainsInitialized = true;
            } else {
                if (!msg.getMsgType().isIgnoreOnStart()) {
                    log.warn("Attempt to initialize Rule Chains by unexpected message: {}", (Object)msg);
                }
                return true;
            }
        }
        switch (msg.getMsgType()) {
            case APP_INIT_MSG: {
                break;
            }
            case PARTITION_CHANGE_MSG: 
            case CF_PARTITIONS_CHANGE_MSG: {
                this.ctx.broadcastToChildren(msg, true);
                break;
            }
            case COMPONENT_LIFE_CYCLE_MSG: {
                this.onComponentLifecycleMsg((ComponentLifecycleMsg)msg);
                break;
            }
            case QUEUE_TO_RULE_ENGINE_MSG: {
                this.onQueueToRuleEngineMsg((QueueToRuleEngineMsg)msg);
                break;
            }
            case TRANSPORT_TO_DEVICE_ACTOR_MSG: {
                this.onToDeviceActorMsg((TenantAwareMsg)msg, false);
                break;
            }
            case DEVICE_ATTRIBUTES_UPDATE_TO_DEVICE_ACTOR_MSG: 
            case DEVICE_CREDENTIALS_UPDATE_TO_DEVICE_ACTOR_MSG: 
            case DEVICE_NAME_OR_TYPE_UPDATE_TO_DEVICE_ACTOR_MSG: 
            case DEVICE_EDGE_UPDATE_TO_DEVICE_ACTOR_MSG: 
            case DEVICE_RPC_REQUEST_TO_DEVICE_ACTOR_MSG: 
            case DEVICE_RPC_RESPONSE_TO_DEVICE_ACTOR_MSG: 
            case SERVER_RPC_RESPONSE_TO_DEVICE_ACTOR_MSG: 
            case REMOVE_RPC_TO_DEVICE_ACTOR_MSG: {
                this.onToDeviceActorMsg((TenantAwareMsg)msg, true);
                break;
            }
            case SESSION_TIMEOUT_MSG: {
                this.ctx.broadcastToChildrenByType(msg, EntityType.TENANT);
                break;
            }
            case CF_CACHE_INIT_MSG: 
            case CF_INIT_PROFILE_ENTITY_MSG: 
            case CF_INIT_MSG: 
            case CF_LINK_INIT_MSG: 
            case CF_STATE_RESTORE_MSG: {
                this.onToCalculatedFieldSystemActorMsg((ToCalculatedFieldSystemMsg)msg, true);
                break;
            }
            case CF_TELEMETRY_MSG: 
            case CF_LINKED_TELEMETRY_MSG: {
                this.onToCalculatedFieldSystemActorMsg((ToCalculatedFieldSystemMsg)msg, false);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void initTenantActors() {
        log.info("Starting main system actor.");
        try {
            if (this.systemContext.isTenantComponentsInitEnabled()) {
                PageDataIterable tenantIterator = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenants(arg_0), 1024);
                for (Tenant tenant : tenantIterator) {
                    log.debug("[{}] Creating tenant actor", (Object)tenant.getId());
                    this.getOrCreateTenantActor(tenant.getId()).ifPresentOrElse(tenantActor -> log.debug("[{}] Tenant actor created.", (Object)tenant.getId()), () -> log.debug("[{}] Skipped actor creation", (Object)tenant.getId()));
                }
            }
            log.info("Main system actor started.");
        }
        catch (Exception e) {
            log.warn("Unknown failure", (Throwable)e);
        }
    }

    private void onQueueToRuleEngineMsg(QueueToRuleEngineMsg msg) {
        if (TenantId.SYS_TENANT_ID.equals((Object)msg.getTenantId())) {
            msg.getMsg().getCallback().onFailure(new RuleEngineException("Message has system tenant id!"));
        } else {
            this.getOrCreateTenantActor(msg.getTenantId()).ifPresentOrElse(actor -> actor.tell((TbActorMsg)msg), () -> msg.getMsg().getCallback().onSuccess());
        }
    }

    private void onComponentLifecycleMsg(ComponentLifecycleMsg msg) {
        TbActorRef target = null;
        if (TenantId.SYS_TENANT_ID.equals((Object)msg.getTenantId())) {
            if (!EntityType.TENANT_PROFILE.equals((Object)msg.getEntityId().getEntityType())) {
                log.warn("Message has system tenant id: {}", (Object)msg);
            }
        } else {
            if (EntityType.TENANT.equals((Object)msg.getEntityId().getEntityType())) {
                TenantId tenantId = TenantId.fromUUID((UUID)msg.getEntityId().getId());
                if (msg.getEvent() == ComponentLifecycleEvent.DELETED) {
                    log.info("[{}] Handling tenant deleted notification: {}", (Object)msg.getTenantId(), (Object)msg);
                    this.deletedTenants.add(tenantId);
                    this.ctx.stop((TbActorId)new TbEntityActorId((EntityId)tenantId));
                    return;
                }
            }
            target = this.getOrCreateTenantActor(msg.getTenantId()).orElseGet(() -> {
                log.debug("Ignoring component lifecycle msg for tenant {} because it is not managed by this service", (Object)msg.getTenantId());
                return null;
            });
        }
        if (target != null) {
            target.tellWithHighPriority((TbActorMsg)msg);
        } else {
            log.debug("[{}] Invalid component lifecycle msg: {}", (Object)msg.getTenantId(), (Object)msg);
        }
    }

    private void onToCalculatedFieldSystemActorMsg(ToCalculatedFieldSystemMsg msg, boolean priority) {
        this.getOrCreateTenantActor(msg.getTenantId()).ifPresentOrElse(tenantActor -> {
            if (priority) {
                tenantActor.tellWithHighPriority((TbActorMsg)msg);
            } else {
                tenantActor.tell((TbActorMsg)msg);
            }
        }, () -> msg.getCallback().onSuccess());
    }

    private void onToDeviceActorMsg(TenantAwareMsg msg, boolean priority) {
        this.getOrCreateTenantActor(msg.getTenantId()).ifPresentOrElse(tenantActor -> {
            if (priority) {
                tenantActor.tellWithHighPriority((TbActorMsg)msg);
            } else {
                tenantActor.tell((TbActorMsg)msg);
            }
        }, () -> {
            if (msg instanceof TransportToDeviceActorMsgWrapper) {
                ((TransportToDeviceActorMsgWrapper)msg).getCallback().onSuccess();
            }
        });
    }

    private Optional<TbActorRef> getOrCreateTenantActor(TenantId tenantId) {
        if (this.deletedTenants.contains(tenantId)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.ctx.getOrCreateChildActor((TbActorId)new TbEntityActorId((EntityId)tenantId), () -> "tenant-dispatcher", () -> new TenantActor.ActorCreator(this.systemContext, tenantId), () -> true));
    }

    @Override
    public ProcessFailureStrategy onProcessFailure(TbActorMsg msg, Throwable t) {
        log.error("Failed to process msg: {}", (Object)msg, (Object)t);
        return this.doProcessFailure(t);
    }

    public static class ActorCreator
    extends ContextBasedCreator {
        public ActorCreator(ActorSystemContext context) {
            super(context);
        }

        public TbActorId createActorId() {
            return new TbEntityActorId((EntityId)TenantId.SYS_TENANT_ID);
        }

        public TbActor createActor() {
            return new AppActor(this.context);
        }
    }
}

