/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.DeviceStateManager;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.MqttClientSettings;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.rule.engine.api.RuleEngineAiChatModelService;
import org.thingsboard.rule.engine.api.SmsService;
import org.thingsboard.rule.engine.api.notification.SlackService;
import org.thingsboard.rule.engine.api.sms.SmsSenderFactory;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbActorSystem;
import org.thingsboard.server.actors.service.ActorService;
import org.thingsboard.server.actors.tenant.DebugTbRateLimits;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.event.CalculatedFieldDebugEvent;
import org.thingsboard.server.common.data.event.ErrorEvent;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.LifecycleEvent;
import org.thingsboard.server.common.data.event.RuleChainDebugEvent;
import org.thingsboard.server.common.data.event.RuleNodeDebugEvent;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.tools.TbRateLimits;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.dao.ai.AiModelService;
import org.thingsboard.server.dao.alarm.AlarmCommentService;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.audit.AuditLogService;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.ClaimDevicesService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.dao.job.JobService;
import org.thingsboard.server.dao.mobile.MobileAppBundleService;
import org.thingsboard.server.dao.mobile.MobileAppService;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateReadExecutor;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateWriteExecutor;
import org.thingsboard.server.dao.notification.NotificationRequestService;
import org.thingsboard.server.dao.notification.NotificationRuleService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.queue.QueueStatsService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.rule.RuleNodeStateService;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.queue.discovery.DiscoveryService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.settings.TbQueueCalculatedFieldSettings;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldQueueService;
import org.thingsboard.server.service.cf.CalculatedFieldStateService;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.component.ComponentDiscoveryService;
import org.thingsboard.server.service.edge.rpc.EdgeRpcService;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.executors.ExternalCallExecutorService;
import org.thingsboard.server.service.executors.NotificationExecutorService;
import org.thingsboard.server.service.executors.PubSubRuleNodeExecutorProvider;
import org.thingsboard.server.service.executors.SharedEventLoopGroupService;
import org.thingsboard.server.service.mail.MailExecutorService;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.rpc.TbCoreDeviceRpcService;
import org.thingsboard.server.service.rpc.TbRpcService;
import org.thingsboard.server.service.rpc.TbRuleEngineDeviceRpcService;
import org.thingsboard.server.service.session.DeviceSessionCacheService;
import org.thingsboard.server.service.sms.SmsExecutorService;
import org.thingsboard.server.service.state.DeviceStateService;
import org.thingsboard.server.service.telemetry.AlarmSubscriptionService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;
import org.thingsboard.server.service.transport.TbCoreToTransportService;
import org.thingsboard.server.utils.DebugModeRateLimitsConfig;

@Component
public class ActorSystemContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActorSystemContext.class);
    private static final FutureCallback<Void> RULE_CHAIN_DEBUG_EVENT_ERROR_CALLBACK = new FutureCallback<Void>(){

        public void onSuccess(@Nullable Void event) {
        }

        public void onFailure(Throwable th) {
            log.error("Could not save debug Event for Rule Chain", th);
        }
    };
    private static final FutureCallback<Void> RULE_NODE_DEBUG_EVENT_ERROR_CALLBACK = new FutureCallback<Void>(){

        public void onSuccess(@Nullable Void event) {
        }

        public void onFailure(Throwable th) {
            log.error("Could not save debug Event for Node", th);
        }
    };
    private static final FutureCallback<Void> CALCULATED_FIELD_DEBUG_EVENT_ERROR_CALLBACK = new FutureCallback<Void>(){

        public void onSuccess(@Nullable Void event) {
        }

        public void onFailure(Throwable th) {
            log.error("Could not save debug Event for Calculated Field", th);
        }
    };
    private final ConcurrentMap<TenantId, DebugTbRateLimits> debugPerTenantLimits = new ConcurrentHashMap<TenantId, DebugTbRateLimits>();
    @Autowired
    private TbApiUsageStateService apiUsageStateService;
    @Autowired
    private TbApiUsageReportClient apiUsageClient;
    @Autowired
    private TbServiceInfoProvider serviceInfoProvider;
    private ActorService actorService;
    @Autowired
    private ComponentDiscoveryService componentService;
    @Autowired
    private DiscoveryService discoveryService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private DeviceProfileService deviceProfileService;
    @Autowired
    private AssetProfileService assetProfileService;
    @Autowired
    private DeviceCredentialsService deviceCredentialsService;
    @Autowired(required=false)
    private DeviceStateManager deviceStateManager;
    @Autowired
    private TbTenantProfileCache tenantProfileCache;
    @Autowired
    private TbDeviceProfileCache deviceProfileCache;
    @Autowired
    private TbAssetProfileCache assetProfileCache;
    @Autowired
    private AssetService assetService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private TenantProfileService tenantProfileService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private UserService userService;
    @Autowired
    private RuleChainService ruleChainService;
    @Autowired
    private RuleNodeStateService ruleNodeStateService;
    @Autowired
    private PartitionService partitionService;
    @Autowired
    private TbClusterService clusterService;
    @Autowired
    private TimeseriesService tsService;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private EventService eventService;
    @Autowired
    private RelationService relationService;
    @Autowired
    private AuditLogService auditLogService;
    @Autowired
    private RuleEngineAiChatModelService aiChatModelService;
    @Autowired
    private AiModelService aiModelService;
    @Autowired
    private EntityViewService entityViewService;
    @Lazy
    @Autowired(required=false)
    private TbEntityViewService tbEntityViewService;
    @Autowired
    private TelemetrySubscriptionService tsSubService;
    @Autowired
    private AlarmSubscriptionService alarmService;
    @Autowired
    private AlarmCommentService alarmCommentService;
    @Autowired
    private JsInvokeService jsInvokeService;
    @Autowired(required=false)
    private TbelInvokeService tbelInvokeService;
    @Autowired
    private MailExecutorService mailExecutor;
    @Autowired
    private SmsExecutorService smsExecutor;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutor;
    @Autowired
    private ExternalCallExecutorService externalCallExecutorService;
    @Autowired
    private NotificationExecutorService notificationExecutor;
    @Lazy
    @Autowired
    private PubSubRuleNodeExecutorProvider pubSubRuleNodeExecutorProvider;
    @Autowired
    private SharedEventLoopGroupService sharedEventLoopGroupService;
    @Autowired
    private MailService mailService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private SmsSenderFactory smsSenderFactory;
    @Autowired
    private NotificationCenter notificationCenter;
    @Autowired
    private NotificationRuleProcessor notificationRuleProcessor;
    @Autowired
    private NotificationTargetService notificationTargetService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;
    @Autowired
    private NotificationRequestService notificationRequestService;
    @Autowired
    private NotificationRuleService notificationRuleService;
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private DomainService domainService;
    @Autowired
    private MobileAppService mobileAppService;
    @Autowired
    private MobileAppBundleService mobileAppBundleService;
    @Autowired
    private SlackService slackService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Lazy
    @Autowired(required=false)
    private ClaimDevicesService claimDevicesService;
    @Autowired(required=false)
    private DeviceStateService deviceStateService;
    @Autowired(required=false)
    private DeviceSessionCacheService deviceSessionCacheService;
    @Autowired(required=false)
    private TbCoreToTransportService tbCoreToTransportService;
    @Lazy
    @Autowired(required=false)
    private ApiLimitService apiLimitService;
    @Autowired(required=false)
    private RateLimitService rateLimitService;
    @Autowired(required=false)
    private DebugModeRateLimitsConfig debugModeRateLimitsConfig;
    @Lazy
    @Autowired(required=false)
    private TbQueueCalculatedFieldSettings calculatedFieldSettings;
    @Lazy
    @Autowired(required=false)
    private TbRuleEngineDeviceRpcService tbRuleEngineDeviceRpcService;
    @Lazy
    @Autowired(required=false)
    private TbCoreDeviceRpcService tbCoreDeviceRpcService;
    @Lazy
    @Autowired(required=false)
    private EdgeService edgeService;
    @Lazy
    @Autowired(required=false)
    private EdgeEventService edgeEventService;
    @Lazy
    @Autowired(required=false)
    private EdgeRpcService edgeRpcService;
    @Lazy
    @Autowired(required=false)
    private ResourceService resourceService;
    @Lazy
    @Autowired(required=false)
    private OtaPackageService otaPackageService;
    @Lazy
    @Autowired(required=false)
    private TbRpcService tbRpcService;
    @Lazy
    @Autowired(required=false)
    private QueueService queueService;
    @Lazy
    @Autowired(required=false)
    private QueueStatsService queueStatsService;
    @Lazy
    @Autowired(required=false)
    private WidgetsBundleService widgetsBundleService;
    @Lazy
    @Autowired(required=false)
    private WidgetTypeService widgetTypeService;
    @Lazy
    @Autowired(required=false)
    private EntityService entityService;
    @Autowired(required=false)
    private CalculatedFieldProcessingService calculatedFieldProcessingService;
    @Autowired(required=false)
    private CalculatedFieldStateService calculatedFieldStateService;
    @Autowired(required=false)
    private CalculatedFieldQueueService calculatedFieldQueueService;
    @Autowired
    private JobService jobService;
    @Autowired
    private JobManager jobManager;
    @Value(value="${actors.session.max_concurrent_sessions_per_device:1}")
    private int maxConcurrentSessionsPerDevice;
    @Value(value="${actors.session.sync.timeout:10000}")
    private long syncSessionTimeout;
    @Value(value="${actors.rule.chain.error_persist_frequency:3000}")
    private long ruleChainErrorPersistFrequency;
    @Value(value="${actors.rule.node.error_persist_frequency:3000}")
    private long ruleNodeErrorPersistFrequency;
    @Value(value="${actors.statistics.enabled:true}")
    private boolean statisticsEnabled;
    @Value(value="${actors.statistics.persist_frequency:3600000}")
    private long statisticsPersistFrequency;
    @Value(value="${edges.enabled:true}")
    private boolean edgesEnabled;
    @Value(value="${cache.type:caffeine}")
    private String cacheType;
    private boolean localCacheType;
    @Value(value="${actors.tenant.create_components_on_init:true}")
    private boolean tenantComponentsInitEnabled;
    @Value(value="${actors.rule.allow_system_mail_service:true}")
    private boolean allowSystemMailService;
    @Value(value="${actors.rule.allow_system_sms_service:true}")
    private boolean allowSystemSmsService;
    @Value(value="${transport.sessions.inactivity_timeout:300000}")
    private long sessionInactivityTimeout;
    @Value(value="${transport.sessions.report_timeout:3000}")
    private long sessionReportTimeout;
    @Value(value="${actors.rpc.submit_strategy:BURST}")
    private String rpcSubmitStrategy;
    @Value(value="${actors.rpc.close_session_on_rpc_delivery_timeout:false}")
    private boolean closeTransportSessionOnRpcDeliveryTimeout;
    @Value(value="${actors.rpc.response_timeout_ms:30000}")
    private long rpcResponseTimeout;
    @Value(value="${actors.rpc.max_retries:5}")
    private int maxRpcRetries;
    @Value(value="${actors.rule.external.force_ack:false}")
    private boolean externalNodeForceAck;
    @Value(value="${state.rule.node.deviceState.rateLimit:1:1,30:60,60:3600}")
    private String deviceStateNodeRateLimitConfig;
    @Value(value="${actors.calculated_fields.calculation_timeout:5}")
    private long cfCalculationResultTimeout;
    @Autowired
    private MqttClientSettings mqttClientSettings;
    private TbActorSystem actorSystem;
    private TbActorRef appActor;
    private TbActorRef statsActor;
    @Autowired(required=false)
    private CassandraCluster cassandraCluster;
    @Autowired(required=false)
    private CassandraBufferedRateReadExecutor cassandraBufferedRateReadExecutor;
    @Autowired(required=false)
    private CassandraBufferedRateWriteExecutor cassandraBufferedRateWriteExecutor;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public ConcurrentMap<TenantId, DebugTbRateLimits> getDebugPerTenantLimits() {
        return this.debugPerTenantLimits;
    }

    @PostConstruct
    public void init() {
        this.localCacheType = "caffeine".equals(this.cacheType);
    }

    public ScheduledExecutorService getScheduler() {
        return this.actorSystem.getScheduler();
    }

    public void persistError(TenantId tenantId, EntityId entityId, String method, Exception e) {
        this.eventService.saveAsync((Event)ErrorEvent.builder().tenantId(tenantId).entityId(entityId.getId()).serviceId(this.getServiceId()).method(method).error(this.toString(e)).build());
    }

    public void persistLifecycleEvent(TenantId tenantId, EntityId entityId, ComponentLifecycleEvent lcEvent, Exception e) {
        LifecycleEvent.LifecycleEventBuilder event = LifecycleEvent.builder().tenantId(tenantId).entityId(entityId.getId()).serviceId(this.getServiceId()).lcEventType(lcEvent.name());
        if (e != null) {
            event.success(false).error(this.toString(e));
        } else {
            event.success(true);
        }
        this.eventService.saveAsync((Event)event.build());
    }

    private String toString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public TopicPartitionInfo resolve(ServiceType serviceType, TenantId tenantId, EntityId entityId) {
        return this.partitionService.resolve(serviceType, tenantId, entityId);
    }

    public TopicPartitionInfo resolve(ServiceType serviceType, String queueName, TenantId tenantId, EntityId entityId) {
        return this.partitionService.resolve(serviceType, queueName, tenantId, entityId);
    }

    public TopicPartitionInfo resolve(TenantId tenantId, EntityId entityId, TbMsg msg) {
        return this.partitionService.resolve(ServiceType.TB_RULE_ENGINE, msg.getQueueName(), tenantId, entityId, msg.getPartition());
    }

    public String getServiceId() {
        return this.serviceInfoProvider.getServiceId();
    }

    public void persistDebugInput(TenantId tenantId, EntityId entityId, TbMsg tbMsg, String relationType) {
        this.persistDebugAsync(tenantId, entityId, "IN", tbMsg, relationType, null, null);
    }

    public void persistDebugInput(TenantId tenantId, EntityId entityId, TbMsg tbMsg, String relationType, Throwable error) {
        this.persistDebugAsync(tenantId, entityId, "IN", tbMsg, relationType, error, null);
    }

    public void persistDebugOutput(TenantId tenantId, EntityId entityId, TbMsg tbMsg, String relationType, Throwable error, String failureMessage) {
        this.persistDebugAsync(tenantId, entityId, "OUT", tbMsg, relationType, error, failureMessage);
    }

    public void persistDebugOutput(TenantId tenantId, EntityId entityId, TbMsg tbMsg, String relationType, Throwable error) {
        this.persistDebugAsync(tenantId, entityId, "OUT", tbMsg, relationType, error, null);
    }

    public void persistDebugOutput(TenantId tenantId, EntityId entityId, TbMsg tbMsg, String relationType) {
        this.persistDebugAsync(tenantId, entityId, "OUT", tbMsg, relationType, null, null);
    }

    private void persistDebugAsync(TenantId tenantId, EntityId entityId, String type, TbMsg tbMsg, String relationType, Throwable error, String failureMessage) {
        if (this.checkLimits(tenantId, tbMsg, error)) {
            try {
                RuleNodeDebugEvent.RuleNodeDebugEventBuilder event = RuleNodeDebugEvent.builder().tenantId(tenantId).entityId(entityId.getId()).serviceId(this.getServiceId()).eventType(type).eventEntity(tbMsg.getOriginator()).msgId(tbMsg.getId()).msgType(tbMsg.getType()).dataType(tbMsg.getDataType().name()).relationType(relationType).data(tbMsg.getData()).metadata(JacksonUtil.toString((Object)tbMsg.getMetaData().getData()));
                if (error != null) {
                    event.error(this.toString(error));
                } else if (failureMessage != null) {
                    event.error(failureMessage);
                }
                ListenableFuture future = this.eventService.saveAsync((Event)event.build());
                Futures.addCallback((ListenableFuture)future, RULE_NODE_DEBUG_EVENT_ERROR_CALLBACK, (Executor)MoreExecutors.directExecutor());
            }
            catch (IllegalArgumentException ex) {
                log.warn("Failed to persist rule node debug message", (Throwable)ex);
            }
        }
    }

    private boolean checkLimits(TenantId tenantId, TbMsg tbMsg, Throwable error) {
        DebugTbRateLimits debugTbRateLimits;
        if (this.debugModeRateLimitsConfig.isRuleChainDebugPerTenantLimitsEnabled() && !(debugTbRateLimits = this.debugPerTenantLimits.computeIfAbsent(tenantId, id -> new DebugTbRateLimits(new TbRateLimits(this.debugModeRateLimitsConfig.getRuleChainDebugPerTenantLimitsConfiguration()), false))).getTbRateLimits().tryConsume()) {
            if (!debugTbRateLimits.isRuleChainEventSaved()) {
                this.persistRuleChainDebugModeEvent(tenantId, (EntityId)tbMsg.getRuleChainId(), error);
                debugTbRateLimits.setRuleChainEventSaved(true);
            }
            if (log.isTraceEnabled()) {
                log.trace("[{}] Tenant level debug mode rate limit detected: {}", (Object)tenantId, (Object)tbMsg);
            }
            return false;
        }
        return true;
    }

    private void persistRuleChainDebugModeEvent(TenantId tenantId, EntityId entityId, Throwable error) {
        RuleChainDebugEvent.RuleChainDebugEventBuilder event = RuleChainDebugEvent.builder().tenantId(tenantId).entityId(entityId.getId()).serviceId(this.getServiceId()).message("Reached debug mode rate limit!");
        if (error != null) {
            event.error(this.toString(error));
        }
        ListenableFuture future = this.eventService.saveAsync((Event)event.build());
        Futures.addCallback((ListenableFuture)future, RULE_CHAIN_DEBUG_EVENT_ERROR_CALLBACK, (Executor)MoreExecutors.directExecutor());
    }

    public void persistCalculatedFieldDebugEvent(TenantId tenantId, CalculatedFieldId calculatedFieldId, EntityId entityId, Map<String, ArgumentEntry> arguments, UUID tbMsgId, TbMsgType tbMsgType, String result, String errorMessage) {
        if (this.checkLimits(tenantId)) {
            try {
                CalculatedFieldDebugEvent.CalculatedFieldDebugEventBuilder eventBuilder = CalculatedFieldDebugEvent.builder().tenantId(tenantId).entityId(calculatedFieldId.getId()).serviceId(this.getServiceId()).calculatedFieldId(calculatedFieldId).eventEntity(entityId);
                if (tbMsgId != null) {
                    eventBuilder.msgId(tbMsgId);
                }
                if (tbMsgType != null) {
                    eventBuilder.msgType(tbMsgType.name());
                }
                if (arguments != null) {
                    eventBuilder.arguments(JacksonUtil.toString(arguments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ArgumentEntry)e.getValue()).toTbelCfArg()))));
                }
                if (result != null) {
                    eventBuilder.result(result);
                }
                if (errorMessage != null) {
                    eventBuilder.error(errorMessage);
                }
                ListenableFuture future = this.eventService.saveAsync((Event)eventBuilder.build());
                Futures.addCallback((ListenableFuture)future, CALCULATED_FIELD_DEBUG_EVENT_ERROR_CALLBACK, (Executor)MoreExecutors.directExecutor());
            }
            catch (IllegalArgumentException ex) {
                log.warn("Failed to persist calculated field debug message", (Throwable)ex);
            }
        }
    }

    private boolean checkLimits(TenantId tenantId) {
        if (this.debugModeRateLimitsConfig.isCalculatedFieldDebugPerTenantLimitsEnabled() && !this.rateLimitService.checkRateLimit(LimitedApi.CALCULATED_FIELD_DEBUG_EVENTS, (Object)tenantId, this.debugModeRateLimitsConfig.getCalculatedFieldDebugPerTenantLimitsConfiguration())) {
            log.trace("[{}] Calculated field debug event limits exceeded!", (Object)tenantId);
            return false;
        }
        return true;
    }

    public static Exception toException(Throwable error) {
        return Exception.class.isInstance(error) ? (Exception)error : new Exception(error);
    }

    public void tell(TbActorMsg tbActorMsg) {
        this.appActor.tell(tbActorMsg);
    }

    public void tellWithHighPriority(TbActorMsg tbActorMsg) {
        this.appActor.tellWithHighPriority(tbActorMsg);
    }

    public ScheduledFuture<?> schedulePeriodicMsgWithDelay(TbActorRef ctx, TbActorMsg msg, long delayInMs, long periodInMs) {
        log.debug("Scheduling periodic msg {} every {} ms with delay {} ms", new Object[]{msg, periodInMs, delayInMs});
        return this.getScheduler().scheduleWithFixedDelay(() -> ctx.tell(msg), delayInMs, periodInMs, TimeUnit.MILLISECONDS);
    }

    public void scheduleMsgWithDelay(TbActorRef ctx, TbActorMsg msg, long delayInMs) {
        log.debug("Scheduling msg {} with delay {} ms", (Object)msg, (Object)delayInMs);
        if (delayInMs > 0L) {
            this.getScheduler().schedule(() -> ctx.tell(msg), delayInMs, TimeUnit.MILLISECONDS);
        } else {
            ctx.tell(msg);
        }
    }

    @Generated
    public TbApiUsageStateService getApiUsageStateService() {
        return this.apiUsageStateService;
    }

    @Generated
    public TbApiUsageReportClient getApiUsageClient() {
        return this.apiUsageClient;
    }

    @Generated
    public TbServiceInfoProvider getServiceInfoProvider() {
        return this.serviceInfoProvider;
    }

    @Generated
    public void setServiceInfoProvider(TbServiceInfoProvider serviceInfoProvider) {
        this.serviceInfoProvider = serviceInfoProvider;
    }

    @Generated
    public ActorService getActorService() {
        return this.actorService;
    }

    @Generated
    public void setActorService(ActorService actorService) {
        this.actorService = actorService;
    }

    @Generated
    public ComponentDiscoveryService getComponentService() {
        return this.componentService;
    }

    @Generated
    public void setComponentService(ComponentDiscoveryService componentService) {
        this.componentService = componentService;
    }

    @Generated
    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    @Generated
    public DeviceService getDeviceService() {
        return this.deviceService;
    }

    @Generated
    public DeviceProfileService getDeviceProfileService() {
        return this.deviceProfileService;
    }

    @Generated
    public AssetProfileService getAssetProfileService() {
        return this.assetProfileService;
    }

    @Generated
    public DeviceCredentialsService getDeviceCredentialsService() {
        return this.deviceCredentialsService;
    }

    @Generated
    public DeviceStateManager getDeviceStateManager() {
        return this.deviceStateManager;
    }

    @Generated
    public TbTenantProfileCache getTenantProfileCache() {
        return this.tenantProfileCache;
    }

    @Generated
    public TbDeviceProfileCache getDeviceProfileCache() {
        return this.deviceProfileCache;
    }

    @Generated
    public TbAssetProfileCache getAssetProfileCache() {
        return this.assetProfileCache;
    }

    @Generated
    public AssetService getAssetService() {
        return this.assetService;
    }

    @Generated
    public DashboardService getDashboardService() {
        return this.dashboardService;
    }

    @Generated
    public TenantService getTenantService() {
        return this.tenantService;
    }

    @Generated
    public TenantProfileService getTenantProfileService() {
        return this.tenantProfileService;
    }

    @Generated
    public CustomerService getCustomerService() {
        return this.customerService;
    }

    @Generated
    public UserService getUserService() {
        return this.userService;
    }

    @Generated
    public RuleChainService getRuleChainService() {
        return this.ruleChainService;
    }

    @Generated
    public RuleNodeStateService getRuleNodeStateService() {
        return this.ruleNodeStateService;
    }

    @Generated
    public PartitionService getPartitionService() {
        return this.partitionService;
    }

    @Generated
    public TbClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public TimeseriesService getTsService() {
        return this.tsService;
    }

    @Generated
    public AttributesService getAttributesService() {
        return this.attributesService;
    }

    @Generated
    public EventService getEventService() {
        return this.eventService;
    }

    @Generated
    public RelationService getRelationService() {
        return this.relationService;
    }

    @Generated
    public AuditLogService getAuditLogService() {
        return this.auditLogService;
    }

    @Generated
    public RuleEngineAiChatModelService getAiChatModelService() {
        return this.aiChatModelService;
    }

    @Generated
    public AiModelService getAiModelService() {
        return this.aiModelService;
    }

    @Generated
    public EntityViewService getEntityViewService() {
        return this.entityViewService;
    }

    @Lazy
    @Generated
    public TbEntityViewService getTbEntityViewService() {
        return this.tbEntityViewService;
    }

    @Generated
    public TelemetrySubscriptionService getTsSubService() {
        return this.tsSubService;
    }

    @Generated
    public AlarmSubscriptionService getAlarmService() {
        return this.alarmService;
    }

    @Generated
    public AlarmCommentService getAlarmCommentService() {
        return this.alarmCommentService;
    }

    @Generated
    public JsInvokeService getJsInvokeService() {
        return this.jsInvokeService;
    }

    @Generated
    public TbelInvokeService getTbelInvokeService() {
        return this.tbelInvokeService;
    }

    @Generated
    public MailExecutorService getMailExecutor() {
        return this.mailExecutor;
    }

    @Generated
    public SmsExecutorService getSmsExecutor() {
        return this.smsExecutor;
    }

    @Generated
    public DbCallbackExecutorService getDbCallbackExecutor() {
        return this.dbCallbackExecutor;
    }

    @Generated
    public ExternalCallExecutorService getExternalCallExecutorService() {
        return this.externalCallExecutorService;
    }

    @Generated
    public NotificationExecutorService getNotificationExecutor() {
        return this.notificationExecutor;
    }

    @Lazy
    @Generated
    public PubSubRuleNodeExecutorProvider getPubSubRuleNodeExecutorProvider() {
        return this.pubSubRuleNodeExecutorProvider;
    }

    @Generated
    public SharedEventLoopGroupService getSharedEventLoopGroupService() {
        return this.sharedEventLoopGroupService;
    }

    @Generated
    public MailService getMailService() {
        return this.mailService;
    }

    @Generated
    public SmsService getSmsService() {
        return this.smsService;
    }

    @Generated
    public SmsSenderFactory getSmsSenderFactory() {
        return this.smsSenderFactory;
    }

    @Generated
    public NotificationCenter getNotificationCenter() {
        return this.notificationCenter;
    }

    @Generated
    public NotificationRuleProcessor getNotificationRuleProcessor() {
        return this.notificationRuleProcessor;
    }

    @Generated
    public NotificationTargetService getNotificationTargetService() {
        return this.notificationTargetService;
    }

    @Generated
    public NotificationTemplateService getNotificationTemplateService() {
        return this.notificationTemplateService;
    }

    @Generated
    public NotificationRequestService getNotificationRequestService() {
        return this.notificationRequestService;
    }

    @Generated
    public NotificationRuleService getNotificationRuleService() {
        return this.notificationRuleService;
    }

    @Generated
    public OAuth2ClientService getOAuth2ClientService() {
        return this.oAuth2ClientService;
    }

    @Generated
    public DomainService getDomainService() {
        return this.domainService;
    }

    @Generated
    public MobileAppService getMobileAppService() {
        return this.mobileAppService;
    }

    @Generated
    public MobileAppBundleService getMobileAppBundleService() {
        return this.mobileAppBundleService;
    }

    @Generated
    public SlackService getSlackService() {
        return this.slackService;
    }

    @Generated
    public CalculatedFieldService getCalculatedFieldService() {
        return this.calculatedFieldService;
    }

    @Lazy
    @Generated
    public ClaimDevicesService getClaimDevicesService() {
        return this.claimDevicesService;
    }

    @Generated
    public DeviceStateService getDeviceStateService() {
        return this.deviceStateService;
    }

    @Generated
    public DeviceSessionCacheService getDeviceSessionCacheService() {
        return this.deviceSessionCacheService;
    }

    @Generated
    public TbCoreToTransportService getTbCoreToTransportService() {
        return this.tbCoreToTransportService;
    }

    @Lazy
    @Generated
    public ApiLimitService getApiLimitService() {
        return this.apiLimitService;
    }

    @Generated
    public RateLimitService getRateLimitService() {
        return this.rateLimitService;
    }

    @Generated
    public DebugModeRateLimitsConfig getDebugModeRateLimitsConfig() {
        return this.debugModeRateLimitsConfig;
    }

    @Lazy
    @Generated
    public TbQueueCalculatedFieldSettings getCalculatedFieldSettings() {
        return this.calculatedFieldSettings;
    }

    @Lazy
    @Generated
    public TbRuleEngineDeviceRpcService getTbRuleEngineDeviceRpcService() {
        return this.tbRuleEngineDeviceRpcService;
    }

    @Lazy
    @Generated
    public TbCoreDeviceRpcService getTbCoreDeviceRpcService() {
        return this.tbCoreDeviceRpcService;
    }

    @Lazy
    @Generated
    public EdgeService getEdgeService() {
        return this.edgeService;
    }

    @Lazy
    @Generated
    public EdgeEventService getEdgeEventService() {
        return this.edgeEventService;
    }

    @Lazy
    @Generated
    public EdgeRpcService getEdgeRpcService() {
        return this.edgeRpcService;
    }

    @Lazy
    @Generated
    public ResourceService getResourceService() {
        return this.resourceService;
    }

    @Lazy
    @Generated
    public OtaPackageService getOtaPackageService() {
        return this.otaPackageService;
    }

    @Lazy
    @Generated
    public TbRpcService getTbRpcService() {
        return this.tbRpcService;
    }

    @Lazy
    @Generated
    public QueueService getQueueService() {
        return this.queueService;
    }

    @Lazy
    @Generated
    public QueueStatsService getQueueStatsService() {
        return this.queueStatsService;
    }

    @Lazy
    @Generated
    public WidgetsBundleService getWidgetsBundleService() {
        return this.widgetsBundleService;
    }

    @Lazy
    @Generated
    public WidgetTypeService getWidgetTypeService() {
        return this.widgetTypeService;
    }

    @Lazy
    @Generated
    public EntityService getEntityService() {
        return this.entityService;
    }

    @Generated
    public CalculatedFieldProcessingService getCalculatedFieldProcessingService() {
        return this.calculatedFieldProcessingService;
    }

    @Generated
    public CalculatedFieldStateService getCalculatedFieldStateService() {
        return this.calculatedFieldStateService;
    }

    @Generated
    public CalculatedFieldQueueService getCalculatedFieldQueueService() {
        return this.calculatedFieldQueueService;
    }

    @Generated
    public JobService getJobService() {
        return this.jobService;
    }

    @Generated
    public JobManager getJobManager() {
        return this.jobManager;
    }

    @Generated
    public int getMaxConcurrentSessionsPerDevice() {
        return this.maxConcurrentSessionsPerDevice;
    }

    @Generated
    public long getSyncSessionTimeout() {
        return this.syncSessionTimeout;
    }

    @Generated
    public long getRuleChainErrorPersistFrequency() {
        return this.ruleChainErrorPersistFrequency;
    }

    @Generated
    public long getRuleNodeErrorPersistFrequency() {
        return this.ruleNodeErrorPersistFrequency;
    }

    @Generated
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Generated
    public long getStatisticsPersistFrequency() {
        return this.statisticsPersistFrequency;
    }

    @Generated
    public boolean isEdgesEnabled() {
        return this.edgesEnabled;
    }

    @Generated
    public String getCacheType() {
        return this.cacheType;
    }

    @Generated
    public boolean isLocalCacheType() {
        return this.localCacheType;
    }

    @Generated
    public boolean isTenantComponentsInitEnabled() {
        return this.tenantComponentsInitEnabled;
    }

    @Generated
    public boolean isAllowSystemMailService() {
        return this.allowSystemMailService;
    }

    @Generated
    public boolean isAllowSystemSmsService() {
        return this.allowSystemSmsService;
    }

    @Generated
    public long getSessionInactivityTimeout() {
        return this.sessionInactivityTimeout;
    }

    @Generated
    public long getSessionReportTimeout() {
        return this.sessionReportTimeout;
    }

    @Generated
    public String getRpcSubmitStrategy() {
        return this.rpcSubmitStrategy;
    }

    @Generated
    public boolean isCloseTransportSessionOnRpcDeliveryTimeout() {
        return this.closeTransportSessionOnRpcDeliveryTimeout;
    }

    @Generated
    public long getRpcResponseTimeout() {
        return this.rpcResponseTimeout;
    }

    @Generated
    public int getMaxRpcRetries() {
        return this.maxRpcRetries;
    }

    @Generated
    public boolean isExternalNodeForceAck() {
        return this.externalNodeForceAck;
    }

    @Generated
    public String getDeviceStateNodeRateLimitConfig() {
        return this.deviceStateNodeRateLimitConfig;
    }

    @Generated
    public long getCfCalculationResultTimeout() {
        return this.cfCalculationResultTimeout;
    }

    @Generated
    public MqttClientSettings getMqttClientSettings() {
        return this.mqttClientSettings;
    }

    @Generated
    public TbActorSystem getActorSystem() {
        return this.actorSystem;
    }

    @Generated
    public void setActorSystem(TbActorSystem actorSystem) {
        this.actorSystem = actorSystem;
    }

    @Generated
    public void setAppActor(TbActorRef appActor) {
        this.appActor = appActor;
    }

    @Generated
    public TbActorRef getStatsActor() {
        return this.statsActor;
    }

    @Generated
    public void setStatsActor(TbActorRef statsActor) {
        this.statsActor = statsActor;
    }

    @Generated
    public CassandraCluster getCassandraCluster() {
        return this.cassandraCluster;
    }

    @Generated
    public CassandraBufferedRateReadExecutor getCassandraBufferedRateReadExecutor() {
        return this.cassandraBufferedRateReadExecutor;
    }

    @Generated
    public CassandraBufferedRateWriteExecutor getCassandraBufferedRateWriteExecutor() {
        return this.cassandraBufferedRateWriteExecutor;
    }

    @Generated
    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }
}

